IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_TRILHO_EXCESSO_FORN]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_TRILHO_EXCESSO_FORN]
GO
  
/****** Object:  StoredProcedure [dbo].[P_TRILHO_EXCESSO_FORN]    Script Date: 03/26/2014 10:46:14 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO 

--EXEC P_TRILHO_EXCESSO_FORN 1
CREATE PROCEDURE [dbo].[P_TRILHO_EXCESSO_FORN] @CD_EMP INT
 WITH ENCRYPTION AS
BEGIN
set nocount on 
DECLARE @FILIAL TABLE (	CD_FILIAL		INT,
						CD_AGENDA		INT, 
						QT_LIMITE_PED	INT DEFAULT 0,  
						QT_PED_GERADO	INT DEFAULT 0,
						PRIMARY KEY(CD_FILIAL, CD_AGENDA));


DECLARE	@mensagemErro	VARCHAR(255),
		@severidadeErro INT,
		@estadoErro		INT;

DECLARE @CONTADOR			INT,
		@CD_MAQUINA			INT,
		@CD_AGENDA			INT,
		@TRILHOS			INT,
		@DT_HOJE			DATETIME,
		@CD_PED				INT,
		@FILIAL_ORIG		INT,
		@CD_DEST			INT,
		@VLR_ATEND			MONEY,
		@CD_NT_MOV_GRP_ECON	INT,
		@CD_NT_MOV 			INT,
		@CD_TRILHO			INT,
		@QT_LIMITE_PED		INT,
		@LINHAS				INT,
		@FLAG_QUEBRA		INT;

DECLARE @RsItem TABLE (CD_EMP	INT,
					   CD_DEST	INT,	
					   CD_NF	INT,
					   CD_FILIAL_ORIG	INT,
					   CD_PROD			INT,			
					   QTDE_PROD		MONEY) 
SELECT 
	@DT_HOJE=dbo.F_HOJE() 
 

--Buscando os trilhos para o cursor na data de hoje
DECLARE cursorTrilhos CURSOR FOR 
SELECT 
	TRILHO.CD_TRILHO, 
	TRILHO.QT_LIMITE_DEST,
	TRILHO_AGENDA.CD_TRILHO_AGENDA,	
	EST_EXCESSO_MAQ_TRILHO.CD_EXCESSO_MAQ
FROM 
	TRILHO 
	INNER JOIN TRILHO_AGENDA ON 
	TRILHO.CD_TRILHO = TRILHO_AGENDA.CD_TRILHO
	INNER JOIN EST_EXCESSO_MAQ_TRILHO ON 
	TRILHO.CD_TRILHO = EST_EXCESSO_MAQ_TRILHO.CD_TRILHO
	INNER JOIN EST_EXCESSO_MAQ M ON
	EST_EXCESSO_MAQ_TRILHO.CD_EMP  = M.CD_EMP AND
	EST_EXCESSO_MAQ_TRILHO.CD_EXCESSO_MAQ  = M.CD_EXCESSO_MAQ
WHERE 
	TRILHO.CD_EMP=@CD_EMP 
	AND TRILHO.STATUS=0 
	AND M.STATUS = 0
	AND (CASE WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 1 THEN --DOMINGO
		DOMINGO
	WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 2 THEN --SEGUNA
		SEGUNDA
	WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 3 THEN --TERCA
		TERCA
	WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 4 THEN --QUARTA
		QUARTA
	WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 5 THEN --QUINTA
		QUINTA
	WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 6 THEN --SEXTA
		SEXTA
	WHEN (DATEPART(WEEKDAY, @DT_HOJE)) = 7 THEN --SABADO
		SABADO
	END) = 1
	AND	M.TP_MAQ=1;--Maq Forn.

OPEN cursorTrilhos;
FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_PED, @CD_AGENDA, @CD_MAQUINA;
WHILE @@FETCH_STATUS = 0
  begin
	
	PRINT '____________________________ INICIO ________________________________'
	PRINT 'PROXIMO TRILHO: CODIGO ' + CONVERT(VARCHAR, @CD_TRILHO) 
	PRINT 'QT_LIMITE :'  + CONVERT(VARCHAR, @QT_LIMITE_PED)
	PRINT 'AGENDA :'  + CONVERT(VARCHAR, @CD_AGENDA)
	PRINT 'MAQUINA :'  + CONVERT(VARCHAR, @CD_MAQUINA)
	
	DELETE 
	FROM 
		TRILHO_MAQ_EXCESSO
	WHERE 
		CD_EXCESSO_MAQ= @CD_MAQUINA  
		AND EXCESSO < 1 ;   

	--Popula as filiais passiveis de participarem no trilho
	DELETE FROM @filial; 
	INSERT INTO @filial (CD_FILIAL, CD_AGENDA, QT_LIMITE_PED, QT_PED_GERADO)
	SELECT 
		CD_FILIAL, 
		CD_TRILHO_AGENDA, 
		@QT_LIMITE_PED QT_LIMITE_PED,  
		0 QT_PED_GERADO
	FROM 
		TRILHO_PRC_FILIAL
	WHERE 
		CD_EMP = @CD_EMP 
		AND CD_TRILHO=@CD_TRILHO 
		AND CD_TRILHO_AGENDA=@CD_AGENDA;


	SELECT @CONTADOR=1, @TRILHOS=0;

	SELECT 
		@TRILHOS = COUNT(CD_FILIAL) 
		FROM 
			UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA)
		WHERE CD_TRILHO = @CD_TRILHO; 

	PRINT convert(varchar, @TRILHOS) + ' - TRILHOS ';

	IF @TRILHOS IS NULL OR @TRILHOS=0 
	begin
		FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_PED, @CD_AGENDA, @CD_MAQUINA;
		CONTINUE;
	end
	BEGIN TRY
		--BEGIN TRANSACTION;
		
		WHILE (@CONTADOR <=@TRILHOS)
			BEGIN

pedidos:
				Print 'Buscando a origem e destino melhor atendidos por valor'

				DELETE FROM @FILIAL
				WHERE QT_PED_GERADO >=QT_LIMITE_PED ;

				SELECT TOP 1					
					@FILIAL_ORIG = FILIAL_ORIG,
					@CD_DEST	 = CD_FORN,	
					@VLR_ATEND   = VLR_ATEND
				FROM
					V_TRILHO_PROD_FORN_ATENDIMENTO A 
					INNER JOIN UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA) B ON
					A.FILIAL_ORIG = B.CD_FILIAL 
					INNER JOIN EST_EXCESSO_MAQ C ON
					A.CD_EMP		 = C.CD_EMP AND
					A.CD_EXCESSO_MAQ = C.CD_EXCESSO_MAQ
					CROSS APPLY (SELECT * FROM DBO.UFD_TRILHO_EXCESSO (A.CD_EMP, FILIAL_ORIG, CD_FORN,1) ) D 
				WHERE
					A.CD_EMP = @CD_EMP
					AND B.CD_TRILHO = @CD_TRILHO
					AND A.CD_EXCESSO_MAQ= @CD_MAQUINA 
					AND A.CD_EXCESSO_MAQ = D.CD_EXCESSO_MAQ 
					AND VLR_ATEND   > C.VLR_LIMITE_TRANSF
					AND FILIAL_ORIG IN 
								(SELECT CD_FILIAL FROM UFD_TRILHO_EXCESSO_RET_FILIAL(@CD_MAQUINA) 
											WHERE 
												EXISTS (SELECT 
															* 
															FROM
												   				@filial
															WHERE
												   				CD_FILIAL = FILIAL_ORIG AND QT_LIMITE_PED > 0)
												AND ENVIA = 1
												AND CD_TRILHO = B.CD_TRILHO) 
				ORDER BY 
					VLR_ATEND DESC;
				
				SET @LINHAS = @@ROWCOUNT;

				PRINT 'Qtde retornada: ' + CONVERT(VARCHAR,@LINHAS) 
				PRINT 'Filial de origem: ' + CONVERT(VARCHAR,@FILIAL_ORIG)
				PRINT 'Fornecedor destino: ' + CONVERT(VARCHAR,@CD_DEST)

				IF @LINHAS=0
					begin
						FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_PED,@CD_AGENDA,@CD_MAQUINA;						
						BREAK;
					end	
					 
			-------------- QUEBRA PEDIDO --------------
			SET @FLAG_QUEBRA = 1;

			WHILE @FLAG_QUEBRA =1
				BEGIN 

					--------------------------------------INSERE O CABECALHO DA VENDA ---------------------------------------------------
					PRINT 'Fornecedor destino ' + CONVERT(VARCHAR, @CD_DEST);
					PRINT 'Maquina de Nr ' + CONVERT(VARCHAR,@CD_MAQUINA); 
					--aproveita a variavel...
					set @FLAG_QUEBRA =isnull((SELECT QT_PED_GERADO FROM @FILIAL
								WHERE CD_FILIAL=@FILIAL_ORIG),0)
					PRINT 'Pedidos gerados..:' + convert(varchar, @FLAG_QUEBRA); 
					set @FLAG_QUEBRA =1;

					--Inserindo itens para abatimento posterior
					DELETE FROM @RsItem --Limpando a tabela temporaria

					IF EXISTS(SELECT QT_PED_GERADO FROM @FILIAL
								WHERE  QT_PED_GERADO >= QT_LIMITE_PED
								and 	CD_FILIAL=@FILIAL_ORIG)
					begin		
						SET @FLAG_QUEBRA = 0;	
						PRINT 'Limite pedido atingido - pula para proximo pedido '									
						goto pedidos;
					end	;

					update  f
					set
						QT_PED_GERADO = isnull(QT_PED_GERADO,0)+1
					from @filial f 
					where 
						CD_FILIAL=@FILIAL_ORIG	;

					------------------------------- RETORNA O CODIGO DO PEDIDO A SER INSERIDO -------------------------------------------
					SET @CD_PED = ISNULL((SELECT MAX(CD_CTR) FROM EST_PROD_TRILHO_EXCESSO  WITH (XLOCK) 
												WHERE CD_EMP=@CD_EMP AND CD_FILIAL=@FILIAL_ORIG), 0) + 1;
					PRINT 'Inserindo O Pedido de Nr ' + CONVERT(VARCHAR, @CD_PED) + ' na Filial ' + CONVERT(VARCHAR, @FILIAL_ORIG);
					------------------------------- RETORNA O CODIGO DO PEDIDO A SER INSERIDO -------------------------------------------
				
					INSERT INTO @RsItem
					SELECT 
						@CD_EMP, 
						@CD_DEST,
						b.CD_NF,
						@FILIAL_ORIG, 
						b.CD_PROD,
						b.QTDE_ATEND QTDE_PROD
					FROM 
						UFD_TRILHO_EXCESSO_FORN (@CD_EMP, @FILIAL_ORIG, @CD_DEST,@CD_MAQUINA) b 				
					WHERE
						b.QTDE_ATEND > 0						
					ORDER BY b.CD_NF;	

					IF @@ROWCOUNT=0 --PULA PARA PROXIMO PEDIDO
						begin		
							SET @FLAG_QUEBRA = 0;	

							DELETE FROM @FILIAL
							WHERE CD_FILIAL = @FILIAL_ORIG ;

							PRINT 'Pula para proximo pedido '									
							goto pedidos;
						end	;
						--Fim
				
					PRINT 'Insere EST_PROD_TRILHO_EXCESSO - Time' + convert(varchar,getdate(),108)

					INSERT INTO EST_PROD_TRILHO_EXCESSO(CD_EMP, CD_FILIAL, CD_CTR,
															DT_TRILHO, STS_TRILHO, CD_DESTINO)
					SELECT 
						@CD_EMP CD_EMP,
						@FILIAL_ORIG CD_FILIAL,
						@CD_PED CD_CTR ,
						CONVERT(DATE,GETDATE()),
						0 STS,
						@CD_DEST;
					
					PRINT 'Insere EST_PROD_TRILHO_EXCESSO_PG_FORN - Time' + convert(varchar,getdate(),108)
					INSERT INTO EST_PROD_TRILHO_EXCESSO_PG_FORN (CD_EMP,CD_FILIAL,CD_CTR,CD_FORN)
					SELECT 
						@CD_EMP CD_EMP,
						@FILIAL_ORIG CD_FILIAL,
						@CD_PED CD_CTR ,
						@CD_DEST;
				
			---------------------------------------- I T E N S  ---------------------------------------
				
					PRINT 'Insere EST_PROD_TRILHO_EXCESSO_ITENS - Time' + convert(varchar,getdate(),108)
					INSERT INTO EST_PROD_TRILHO_EXCESSO_ITENS (CD_EMP, CD_FILIAL, CD_CTR ,CD_PROD ,
																QTDE_EXCESSO ,QTDE_ENVIADA) 
					SELECT 
						@CD_EMP, 
						@FILIAL_ORIG, 
						@CD_PED, 
						i.CD_PROD,
						i.QTDE_PROD,
						i.QTDE_PROD
					FROM @RSITEM i;
				 

					PRINT 'Insere EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT - Time' + convert(varchar,getdate(),108)
					INSERT INTO EST_PROD_TRILHO_EXCESSO_ITENS_EST_NF_ENT_IT (CD_EMP,CD_FILIAL,CD_NF,CD_PROD,CD_CTR)
					SELECT 
						@CD_EMP, 
						@FILIAL_ORIG, 
						I.CD_NF,
						i.CD_PROD,
						@CD_PED
					FROM @RSITEM i;
				 
					PRINT 'Insere EST_PROD_TRILHO_EXCESSO_ITENS_EST_PROD_CPL_LOTE - Time' + convert(varchar,getdate(),108)
					INSERT INTO EST_PROD_TRILHO_EXCESSO_ITENS_EST_PROD_CPL_LOTE (CD_EMP,CD_FILIAL,CD_CTR,CD_PROD,CD_LOTE,QTDE_LOTE)
					SELECT 
						@CD_EMP, 
						@FILIAL_ORIG, 
						@CD_PED,					
						i.CD_PROD,
						L.CD_LOTE,
						CASE WHEN i.QTDE_PROD > L.QTDE_PROD THEN L.QTDE_PROD
							ELSE I.QTDE_PROD  END
					FROM 
						@RSITEM i
						INNER JOIN EST_NF_ENT_IT_EST_PROD_CPL_LOTE L ON 
						@CD_EMP			= L.CD_EMP	AND
						CD_FILIAL_ORIG	= L.CD_FILIAL	AND	
						I.CD_NF			= L.CD_NF	AND
						I.CD_PROD		= L.CD_PROD
					PRINT 'Total de ' + CONVERT(VARCHAR, @@ROWCOUNT) + ' Itens'
					PRINT 'Inseridos os itens do pedido de Nr ' + CONVERT(VARCHAR, @CD_PED) + ' na filial ' + CONVERT(VARCHAR,@FILIAL_ORIG)
					
			------------------------------- ATUALIZA A TABELA DE NECESSIDADES -------------------------------

					PRINT 'Atualiza as necessidades com o trilho gerado- Time' + convert(varchar,getdate(),108)
				
					UPDATE N
					SET 
						N.NECESSIDADE = (N.NECESSIDADE - B.QTDE_PROD)
					FROM
				 		TRILHO_PROD_NECESSIDADE_FORN N
						INNER JOIN @RSITEM B ON
						N.CD_EMP	= B.CD_EMP AND
						N.CD_FORN   = B.CD_DEST AND
						N.CD_PROD	= B.CD_PROD 
					WHERE
						N.DT_MOV =   @DT_HOJE 
						AND N.CD_EMP=@CD_EMP
						and n.CD_FILIAL=@FILIAL_ORIG
						AND N.CD_EXCESSO_MAQ=@CD_MAQUINA
						AND N.CD_FORN = @CD_DEST;
					 
					UPDATE E
					SET 
						E.QT_IT= (E.QT_IT - B.QTDE_PROD)
					FROM
				 		TRILHO_PROD_NECESSIDADE_FORN N
						INNER JOIN @RSITEM B ON
						N.CD_EMP	= B.CD_EMP AND
						N.CD_FORN   = B.CD_DEST AND
						N.CD_PROD	= B.CD_PROD
					  
						INNER JOIN TRILHO_PROD_NECESSIDADE_FORN_EST_NF_ENT E ON 
						N.CD_CTR = E.CD_CTR AND 
						B.CD_NF  = E.CD_NF
					WHERE
						N.DT_MOV	 = @DT_HOJE 
						AND N.CD_EMP = @CD_EMP
						AND N.CD_EXCESSO_MAQ = @CD_MAQUINA
						AND N.CD_FORN        = @CD_DEST;

			-------------------------------- ATUALIZA A TABELA DE EXCESSO -------------------------------
					UPDATE e
						SET e.EXCESSO = (e.EXCESSO - b.QTDE_PROD)
					FROM
						TRILHO_MAQ_EXCESSO e
						INNER JOIN @RSITEM b ON
						e.CD_EMP  = b.CD_EMP AND
						e.CD_PROD = b.CD_PROD
					WHERE
						e.DT_MOV = @DT_HOJE	
						AND e.CD_EMP=@CD_EMP
						AND e.CD_EXCESSO_MAQ= @CD_MAQUINA
						AND e.CD_FILIAL = @FILIAL_ORIG;
  
				END
			SET @CONTADOR = @CONTADOR + 1;		
		END	 
		--COMMIT TRANSACTION;
	END TRY

	BEGIN CATCH
		--IF @@NESTLEVEL > 0  ROLLBACK TRANSACTION;----------------------------------------------------------------------------------
		INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
			SELECT
				ERROR_NUMBER() AS numero,
				ERROR_SEVERITY() AS severidade,
				ERROR_STATE() AS estado,
				ERROR_PROCEDURE() AS rotina,
				ERROR_LINE() AS linha,
				ERROR_MESSAGE() AS mensagem,
				GETDATE() AS dtErro;
		CLOSE cursorTrilhos;
		DEALLOCATE cursorTrilhos;
		RETURN -1
	END CATCH

	END
	
	FETCH NEXT FROM cursorTrilhos INTO @CD_TRILHO, @QT_LIMITE_PED,@CD_AGENDA,@CD_MAQUINA;
	
  end
CLOSE cursorTrilhos;
DEALLOCATE cursorTrilhos;
RETURN

